/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.cluster.impl.network.IPMICheckImpl;
import oracle.cluster.network.IPMICheckException;
import oracle.cluster.network.IPMICheckResult;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskIPMIChecks
extends Task
implements VerificationConstants,
VerificationAPIConstants {
    private boolean m_isPreCRS = false;
    private static final String CRSCTL_IPMI_MSG = "";
    private String m_crsHome = null;

    public TaskIPMIChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskIPMIChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskIPMIChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setIsPreCRS(boolean isPreCRS) {
        this.m_isPreCRS = isPreCRS;
    }

    @Override
    public boolean performTask() {
        boolean retVal = false;
        Trace.out((String)"Performing IPMI configuration check...");
        ReportUtil.sureprintln(s_msgBundle.getMessage("10303", false));
        retVal = this.m_isPreCRS ? this.performIPMIPreInstCheck() : this.performIPMIPostInstCheck();
        if (retVal) {
            Trace.out((String)"IPMI configuration check was passed");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10305", false));
            this.m_resultSet.addResult(this.m_nodeList, 1);
        }
        return retVal;
    }

    private boolean performIPMIPreInstCheck() {
        IPMICheckImpl ipmiCheck = new IPMICheckImpl();
        IPMICheckResult[] results = null;
        boolean retVal = true;
        StringBuffer badNodes = new StringBuffer();
        Trace.out((String)"ENTRY");
        try {
            results = ipmiCheck.checkIPMI(this.m_nodeList);
        }
        catch (IPMICheckException iex) {
            Trace.out((String)("IPMICheckException occured while calling checkIPMI() on IPMICheck. ex=" + iex.getMessage()));
            results = iex.getIPMICheckResults();
        }
        for (int i = 0; i < results.length; ++i) {
            if (!results[i].ipmiDeviceExists()) {
                if (!retVal) {
                    badNodes.append(", ");
                } else {
                    retVal = false;
                }
                badNodes.append(results[i].getNodeName());
                continue;
            }
            this.m_resultSet.addResult(results[i].getNodeName(), 1);
        }
        if (!retVal) {
            String errMsg = s_msgBundle.getMessage("10304", true, (Object[])new String[]{badNodes.toString()});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(badNodes.toString().split(", "), 3);
        }
        Trace.out((String)"END");
        return retVal;
    }

    private boolean performIPMIPostInstCheck() {
        Trace.out((String)"ENTRY");
        this.m_crsHome = this.getCRSHome();
        if (this.m_crsHome == null) {
            return false;
        }
        Trace.out((String)"Trying to get IPMI IP addresses...");
        String[] ipmiIPAddrs = this.getIpmiIPAddrs(this.m_nodeList);
        if (ipmiIPAddrs == null) {
            return false;
        }
        if (!this.performIPMIPingCheck(this.m_nodeList, ipmiIPAddrs)) {
            return false;
        }
        if (!this.performIPMICredentialsCheck(this.m_nodeList, ipmiIPAddrs)) {
            return false;
        }
        Trace.out((String)"END");
        return true;
    }

    private boolean performIPMIPingCheck(String[] nodes, String[] ipAddrs) {
        Object vipResName = null;
        VerificationCommand[] cmds = new VerificationCommand[nodes.length];
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uex) {
            Trace.out((Object)"exception while getting local host name. exception=", (String)uex.getMessage());
            String errMsg = s_msgBundle.getMessage("0002", true) + uex.getMessage();
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(localNode, errDesc);
            return false;
        }
        for (int i = 0; i < cmds.length; ++i) {
            String[] args = new String[]{"-chkIpmi", "ip=" + ipAddrs[i]};
            cmds[i] = localNode.equals(nodes[i]) ? (i + 1 == cmds.length ? new VerificationCommand(nodes[0], args, null) : new VerificationCommand(nodes[i + 1], args, null)) : new VerificationCommand(localNode, args, null);
            Trace.out((String)("IPMI ping with IP " + ipAddrs[i] + " is performed from node " + cmds[i].getNodeName()));
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            boolean bTimeout = false;
            for (int i = 0; i < cmds.length; ++i) {
                String cmdOutput = cmds[i].getOutput();
                Trace.out((String)("got ping cmd output: " + cmdOutput));
                if (!"ping=1".equals(cmdOutput)) {
                    bTimeout = true;
                    String errMsg = s_msgBundle.getMessage("10307", true, (Object[])new String[]{ipAddrs[i], nodes[i]});
                    Trace.out((String)errMsg);
                    ReportUtil.sureprintln(errMsg);
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.getResult(nodes[i]).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(nodes[i], 3);
                    continue;
                }
                this.m_resultSet.addResult(nodes[i], 1);
            }
            return !bTimeout;
        }
        this.m_resultSet.uploadResultSet(rs);
        String[] failedNodes = rs.getFailureNodes();
        String strFailedNodes = VerificationUtil.strArr2List(failedNodes);
        Trace.out((String)("exectask -chkIpmi failed on nodes" + strFailedNodes));
        String errMsg = s_msgBundle.getMessage("5302", true, (Object[])new String[]{strFailedNodes});
        ReportUtil.sureprintln(errMsg);
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(failedNodes, errDesc);
        this.m_resultSet.addResult(failedNodes, 2);
        return false;
    }

    private boolean performIPMICredentialsCheck(String[] nodes, String[] ipAddrs) {
        Trace.out((String)"Trying to perform IPMI credentials check...");
        String crsHome = this.m_crsHome;
        String crsctl = crsHome + FSEP + "bin" + FSEP + "crsctl";
        VerificationCommand[] cmds = new VerificationCommand[nodes.length];
        for (int i = 0; i < cmds.length; ++i) {
            String[] args = new String[]{"-rungencmd", crsctl, "set css ipmiaddr", null};
            args[3] = ipAddrs[i];
            cmds[i] = new VerificationCommand(nodes[i], args, null);
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            boolean bLogin = true;
            for (int i = 0; i < cmds.length; ++i) {
                String cmdOutput = cmds[i].getOutput();
                Trace.out((String)("'set css ipmiaddr' command output on node " + nodes[i] + " :" + cmdOutput));
                if (cmdOutput != null && cmdOutput.startsWith(CRSCTL_IPMI_MSG)) {
                    Trace.out((String)("IPMI credentials check is passed on node " + nodes[i]));
                    continue;
                }
                bLogin = false;
                String errMsg = s_msgBundle.getMessage("10308", true, (Object[])new String[]{nodes[i]});
                Trace.out((String)errMsg);
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(nodes[i], errDesc);
            }
            if (!bLogin) {
                return false;
            }
        } else {
            this.m_resultSet.uploadResultSet(rs);
            String[] failedNodes = rs.getFailureNodes();
            String strFailedNodes = VerificationUtil.strArr2List(failedNodes);
            Trace.out((String)(crsctl + " set css ipmiaddr failed on nodes " + strFailedNodes));
            String cmd = crsctl + " set css ipmiaddr";
            String errMsg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{cmd, strFailedNodes});
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(failedNodes, errDesc);
            this.m_resultSet.addResult(failedNodes, 2);
        }
        return true;
    }

    private String[] getIpmiIPAddrs(String[] nodeList) {
        String[] ips = new String[nodeList.length];
        Trace.out((String)"Trying to get IPMI IP address");
        String crsHome = this.m_crsHome;
        String crsctl = crsHome + FSEP + "bin" + FSEP + "crsctl";
        String[] args = new String[]{"-rungencmd", crsctl, "get css ipmiaddr"};
        VerificationCommand[] cmds = new VerificationCommand[nodeList.length];
        for (int i = 0; i < cmds.length; ++i) {
            cmds[i] = new VerificationCommand(nodeList[i], args, null);
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            boolean invalidIP = false;
            for (int i = 0; i < cmds.length; ++i) {
                String ipmiIpAddr = cmds[i].getOutput().trim();
                try {
                    Trace.out((String)("got IPMI IP address " + ipmiIpAddr + " on node " + nodeList[i]));
                    InetAddress.getByName(ipmiIpAddr);
                    ips[i] = ipmiIpAddr;
                    continue;
                }
                catch (UnknownHostException uex) {
                    invalidIP = true;
                    Trace.out((String)("UnknownHostException : " + uex.getMessage()));
                    Trace.out((String)("invalid IPMI Ip address on node " + nodeList[i]));
                    String errMsg = s_msgBundle.getMessage("10306", true, (Object[])new String[]{nodeList[i]});
                    ReportUtil.sureprintln(errMsg);
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(nodeList[i], errDesc);
                }
            }
            if (invalidIP) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
                return null;
            }
        } else {
            this.m_resultSet.uploadResultSet(rs);
            String[] failedNodes = rs.getFailureNodes();
            String strFailedNodes = VerificationUtil.strArr2List(failedNodes);
            Trace.out((String)(crsctl + " get css ipmiaddr failed on nodes " + strFailedNodes));
            String cmd = crsctl + " get css ipmiaddr";
            String errMsg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{cmd, strFailedNodes});
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(failedNodes, errDesc);
            this.m_resultSet.addResult(failedNodes, 2);
            return null;
        }
        return ips;
    }

    String getCRSHome() {
        Trace.out((String)"Trying to get CRS Home ...");
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"Failed to get CRS HOME.");
            String msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return null;
        }
        Trace.out((String)("Got CRS Home: " + crsHome));
        return crsHome;
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_isPreCRS) {
            return s_msgBundle.getMessage("10301", false);
        }
        return s_msgBundle.getMessage("10302", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("10300", false);
    }
}

